(function($){
	$.widget("mobile.orderManagement", {
		options: {
			refreshTime: (5)*60*1000,
			clear: null,
			page: '#order-viewer',
			links: {

			},
			patient: {
				lastName: '',
				firstName: '',
				gender: '',
				ssn: '',
				age: '',
				patientIdentifier: {
					uniqueId: ''
				}
			}
		},
		open: function() {
			if (Backbone.history.fragment.indexOf("orders") != -1) {
				Portal.OrdersApplet.vent.trigger("show:summary");
			} else {
				var that = this,
					o = this.options,
					$leftPanel = $('.ui-panel-position-left.ui-panel-open');
				if (!$leftPanel.length) {
					this.orders = this._app().getCollections().orders();
					o.templates = this._templates().get();
					this.$el = $().add(o.templates.main);
					this._buildMain();
				}
				$(o.page).panel("open");
			}
		},
		close: function() {
			if (this.omXHRRequest) {
				this.omXHRRequest.abort();
			}
			clearTimeout(this.refreshTimer);
			$.mobile.loading('hide');
			$(this.options.page).panel("close");
		},
		destroy: function() {
			var $page = $(this.options.page),
				that = this;
			if ($('.ui-panel-content-wrap').hasClass('ui-panel-content-wrap-closed')) {
				that._destroyChildWidgets();
				this.options.clinicalEvent = null;
				$page.remove();
			} else {
				$page.one('panelclose', function() {
					that._destroyChildWidgets();
					that.options.clinicalEvent = null;
					$page.remove();
					$page.off();
				});

				this.close();
			}
		},
		_destroyChildWidgets: function() {
			var childCreated = this.options.childCreated;

			if (typeof childCreated !== "undefined") {
				if (childCreated.note) {
					$('#note-section').note('destroy');
				}
				if (childCreated.link) {
					$('#link-section').link('destroy');
				}
				if (childCreated.encounter) {
					$('#encounter-section').encounter('destroy');
				}
				if (childCreated.sign) {
					$('#sign-section').sign('destroy');
				}
			}
		},
		_buildMain: function() {
			var o = this.options,
				that = this;
			if (!$(o.page).hasClass('ui-panel')) {
				$('.ui-page-active').append(this.$el);
				//Load in content and placeholders
				this._render(function() {
					$(o.page)
						.trigger('create')
						.panel({
							position:"right",
							display:"reveal",
							dismissible: false
						});
					$('#ov-update').button('disable');
					$('.ov-head-btn').addClass('ui-disabled');
					that._delegateEvents();
					$(window).trigger("resize");
				});
			}
			if (!that.OrderView) {
				//Initialize Backbone view
				var OrderView = this._app().getViews().orderView();
				this.OrderView = new OrderView();
			}
		},
		// Set up the widget
		_create: function() {
		},
		update: function(arguments){
			var that = this;
			this.destroy();
			$.extend(that.options, arguments);
			this._initialize();
		},
		_initialize: function() {
			this.app = this._app();
			this._drawBtn();
		},
		_drawBtn: function() {
			var $ordersTabBtn = this.element,
				that = this;
			$ordersTabBtn.off();
			$ordersTabBtn.bind('tap', function(e) {
				e.preventDefault();
				that.toggle();
			});
			$ordersTabBtn.bind('keyup', function(e) {
				e.preventDefault();
				var key = e.which;
				if (key === 13 || key === 32) { //Enter || Space Bar
					that.toggle();
				}
			});
		},
		toggle: function() {
			if ($('#order-viewer').hasClass('ui-panel-open')) {
				this.close();
			} else {
				this.open();
			}
		},
		publicGet: function(url, callbackFn) {
			$.ajax({
				accept: 'application/json',
				type: 'GET',
				url: url,
				dataType: 'json',
				success: function(data){
					if ($.isFunction(callbackFn)) {
						callbackFn.call(data);
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					console.log(XMLHttpRequest);
				},
				statusCode: {
					404: function() {
						if ($.isFunction(callbackFn)) {
							callbackFn.call(data);
						}
					}
				}
			});
		},
		// Use the _setOption method to respond to changes to options
		_setOption: function(key, value) {
			switch(key){
				case "#":
					break;
			}
		},
		_render: function(callbackFn) {
			var o = this.options;
			var templates = o.templates,
				html = [];
			html.push([templates.header,
				templates.content].join(''));
			this.$el.empty().append(html);
			if ($.isFunction(callbackFn)) {
				callbackFn.call();
			}
		},
		_delegateEvents: function(){
			var direction;
			var that = this,
				o = this.options;
			$page = $(o.page);
			$page.on('tap','#ov-update',function(e){
				that.OrderView.refresh(e);
			});
			$page.on('tap',".ov-group-table tr.ui-btn",function(e){
				that.OrderView.orderDetails(e);
			});
			// Expand all and collapse all functionality
			$page.on('tap', '#ov-expand-all', function() {
				$(".ov-group-panel").trigger('expand');
			});
			$page.on('tap', '#ov-collapse-all', function() {
				$(".ov-group-panel").trigger('collapse');
			});
			$page.on('tap', '#open-om', function () {
				that.close();
			});
		},
		_writeToStorage: function(key, value) {
			if (value) {
				try {
					window.localStorage[key] = JSON.stringify(value);
				} catch(e) {
					if(e == QUOTA_EXCEEDED_ERR){
						var message = 'Local-Storage Quota exceeded!';
						if (window.console && window.console.log) {
							console.log(message);
						} else {
							alert(message);
						}
					}
				}
			}
		},
		_readFromStorage: function(key) {
			var value = null;
			if (typeof(window.localStorage) != 'undefined') {
				value = JSON.parse(window.localStorage[key] || null);
			}
			return value;
		},
		_removeFromStorage: function(key) {
			if (typeof(window.localStorage) != 'undefined') {
				window.localStorage.removeItem(key);
			}
		},		
		_flattenLinks: function(object) {
			var links = object.link;
			if (typeof links !== 'undefined') {
				size = links.length;
				for (var i = 0; i < size; i++) {
					if (links[i].title) {
						object[links[i].title] = links[i];
					} else {
						object[links[i]] = links[i];
					}
				}
			}
			delete object.link;
			return object;
		},
		_getFormattedTime:function(date) {
			var hrs = date.getHours(),
				min = date.getMinutes(),
				meridiem = "am";
			if (hrs>11) {
				meridiem = "pm";
			}
			if (hrs>12) {
				hrs = hrs-12;
			}
			if (min<10) {
				min = "0"+min;
			}
			return hrs + ":" + min + meridiem;
		},
		_convertToID: function(string) {
			return string.toLowerCase().replace(" ","-");
		},
		_app: function() {
			'use strict';
			var o = this.options,
				that = this,
				models = {
					order: function() {
						return Backbone.Model.extend({
							initialize: function() {
								this.id = this.get('orderId');
							}
						});
					}
				},
				collections = {
					orders: function() {
						var Collection = Backbone.Collection.extend({
							url: o.resourceURI,
							// url: "applets/orders-management/devdata/orders.json",
							model: that.app.getModels().order(),
							initialize: function () {
								this.getLatestOrders(function() {
									that.OrderView.render();
								});
							},
							getLatestOrders: function(callbackFn) {
								var _this = this;
								$('#ov-update').button('disable');
								$('.ov-head-btn').addClass('ui-disabled');

								$.mobile.loading('show');
								that.omXHRRequest = this.fetch({
									success: function(){
										var now = new Date();
										that.collectionTime = that._getFormattedTime(now);

										if ($.isFunction(callbackFn)) {
											callbackFn();
										}
									},
									error: function(XMLHttpRequest, textStatus, errorThrown) {
										$('#ov-update-time').empty().append("ERROR");
									}
								}).always(function() {
									$('#ov-update').button('enable');
									$('.ov-head-btn').removeClass('ui-disabled');
									$.mobile.loading('hide');
								});
							},
							parse: function(data) {
								var parsedData = data.order;
								return parsedData;
							},
							pending: function() {
								return this.where({"status":"Pending"});
							},
							active: function() {
								return this.where({"status":"Active"});
							},
							groups: function() {
								return _.uniq(this.pluck('orderGrouping'));
							},
							groupData: function() {
								var data = [],
									groups = this.groups(),
									i = 0;
								for (i; i<groups.length; i++) {
									var g = groups[i],
										gd = {
											"id": that._convertToID(g),
											"name": g,
											"inpatient": this.where({"orderGrouping":g,"orderType":"Inpatient"}).length,
											"outpatient": this.where({"orderGrouping":g,"orderType":"Outpatient"}).length,
											"groupOrders": this.where({"orderGrouping":g}),
										};
									data.push(gd);
								}
console.log(data);
								return data;
							}
						});
						return new Collection();
					}
				},
				views = {
					orderView: function() {
						var View = Backbone.View.extend({
							id: 'ov-view',
							initialize: function() {
								this.accordion = _.template(o.templates.accordion);
								this.accordionPanel = _.template(o.templates.accordionPanel);
								this.newButton = _.template(o.templates.newButton);
								this.panelTable = _.template(o.templates.panelTable);
								this.orderRow = _.template(o.templates.orderRow);
							},
							render: function() {
								this.orders = that.orders;
								var _this = this,
									$container = this.$el.empty().append(this.accordion);
								this.orders.on('add remove',function(){
									_this.updatePanels();
								});
								$(o.page).find(":jqmData(role='content')").empty().append($container);
								this.createPanels();
								this.headerData();
								$(o.page).trigger('create');
								this.autoRefresh();
							},
							autoRefresh: function() {
								var _this = this;
								//initiate auto-refresh
								that.refreshTimer = setTimeout(function() {
									_this.refresh();
									_this.autoRefresh();
								}, o.refreshTime);
							},
							refresh: function() {
								this.orders.getLatestOrders(function() {
									$('#ov-update-time').empty().append(that.collectionTime);
								});
							},
							headerData: function() {
								$('#ov-update-time').empty().append(that.collectionTime);
							},
							createPanels: function() {
								var that = this,
									groupData = this.orders.groupData(),
									accordion = this.$el.find('#ov-groups').empty();
								_.each(groupData, function(group){
									var template = _.template(that.accordionPanel(group));
									accordion.append(template);
									that.createTable(group);
								});
							},
							createTable: function(group) {
								var that = this,
									id = group.id,
									$panel = this.$el.find('#ov-groups div#'+id),
									tableTemplate = _.template(this.panelTable(group));
								if (group.name==="Medication") {
									var serviceOrders = _.groupBy(group.groupOrders,function(order){
											return order.get("orderType");
										}),
										subcatTemplate = _.template(o.templates.subcategory);
									$panel.empty();
									_.each(serviceOrders, function(orderType, subcategory){
										var $subcatSection = $(subcatTemplate({subcategoryName: subcategory}));
										$subcatSection.append(tableTemplate());
										_.each(orderType, function(order){
											var row = _.template(that.orderRow(order.attributes));
											$subcatSection.find('tbody').append(row);
										});
										$panel.append($subcatSection);
									});
								} else {
									$panel.empty().append(tableTemplate);
									_.each(group.groupOrders, function(order){
										var row = _.template(that.orderRow(order.attributes));
										$panel.find('tbody').append(row);
									});
								}
							},
							updatePanels: function() {
								this.createPanels();
								//this function only triggers if there is a CHANGE in the response. If the fetch response is the same this will not fire. Easiest to test this with local data.
							},
							orderDetails: function(e) {
								var $this = $(e.currentTarget),
									id = $this.attr('id'),
									thisDetail = this.orders.get(id).get('orderDetail');
								$('#orderDetailsContent').empty().append("<h3>Order Details</h3><pre>"+thisDetail+"</pre>").css('max-height',($(window).height()-60)+"px");
								$('#orderDetails').popup('open');
							}
						});
						return View;
					}
				};
			return {
				getViews: function() {
					return views;
				},
				getModels: function() {
					return models;
				},
				getCollections: function() {
					return collections;
				}
			};
		},
		_templates: function() {
			/*jshint multistr: true */
			/* HELPERS */
			var capitalizeFirstLetter = function(string) {
				'use strict';
				string = string.toLowerCase();
				return string.charAt(0).toUpperCase() + string.slice(1);
			};
			var o = this.options;
			initButton = {
				title: {
					single: '',
					plural: ''
				},
				count: '<span class="ui-li-count ui-btn-up-c ui-btn-corner-all">' + o.inprogress + '</span>'
			},
			templates = {
				main: '<div id="' + o.page.replace('#', '') + '" data-role="panel" class=""><div>',
				header: '<div data-role="header" class="ui-header ui-bar-d" data-theme="d"> \
							<h3 class="ui-title" role="heading" aria-level="1">Orders Viewer</h3> \
							<a id="open-om" class="ui-btn-right" href="#orders" data-inline="true" data-icon="edit" data-role="button" data-theme="a">Manager</a> \
						</div>',
				content: '<div data-role="content" class="scrollable padded"></div>',
				accordion: '<div id="ov-timestamp-container" class="ov-timestamp-container"> \
						<div class="ov-head-data ov-timestamp">Last Updated: <span id="ov-update-time"></span></div> \
						<button class="ov-head-update ov-head-btn" id="ov-update" data-icon="refresh" data-mini="true" data-inline="true" data-iconpos="notext" data-theme="a">Reload</button> \
					</div> \
					<div class="ui-grid-a"><div class="ui-block-a"><button data-theme="d" data-mini="true" id="ov-expand-all">Expand All</button></div><div class="ui-block-b"><button data-theme="d" data-mini="true" id="ov-collapse-all">Collapse All</button></div></div> \
					<div id="ov-groups"></div> \
					<div data-role="popup" id="orderDetails" class="ov-details-popup" data-theme="c" data-overlay-theme="a"><a href="#" data-rel="back" data-role="button" data-theme="c" data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close</a><div id="orderDetailsContent" class="ov-details-content"></div></div>',
				accordionPanel: '<div data-role="collapsible" data-mini="true" data-theme="b" data-content-theme="d"  data-inset="false" class="ov-group-panel"> \
						<h3> \
							<% if (name === "Medication") { %> \
								<div class="ov-group-status">InPt <%= inpatient %> / OutPt <%= outpatient %></div> \
							<% } else { %> \
								<div class="ov-group-status"><%= groupOrders.length %></div> \
							<% } %> \
							<%= name %> \
						</h3> \
						<div id="<%= id %>"></div> \
					</div>',
				panelTable: '<table class="ov-group-table"> \
						<thead> \
							<tr> \
								<th class="ui-bar ui-bar-d">Order Name</th> \
								<th class="ui-bar ui-bar-d">Start&nbsp;Date&nbsp;- End&nbsp;Date</th> \
								<th class="ui-bar ui-bar-d">Status</th> \
							</tr> \
						</thead> \
						<tbody></tbody> \
					</table>',
				orderRow: '<tr class="ui-btn ui-li ui-btn-up-c" data-theme="c" title="Tap to see details." id="<%= orderId %>"> \
							<td><%= orderText %> \
							<% if (orderGrouping === "Medication") { %> \
								<br><strong><%= orderType %><strong> \
							<% } %> \
							</td> \
							<td><%= startDate %> - <%= stopDate %></td> \
							<td><%= status %></td>  \
						<tr>',
				subcategory: '<div id="<%= subcategoryName %>-sub-cat"><h4 class="ov-sub-cat"><%= subcategoryName %></h4></div>'
			}
			return {
				get: function() {
					return templates;
				}
			};
		}
	});
}(jQuery));